﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class ReadForm
    ' 存储用户要查看的日志的名称。
    Private logType As String = ""

    Private Sub cmdViewLogEntries_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnViewLogEntries.Click
        Try
            Const EntriesToDisplay As Integer = 10

            ' 在本例中，向 EventLog 构造函数传递一个表示该日志名的字符串变量。
            ' 这是因为应用程序的用户可以从窗体的
            ' 列表框中选择要查看哪个日志。
            Dim ev As New EventLog(logType, System.Environment.MachineName, _
                "Event Log Sample")

            rchEventLogOutput.Text = "Event log entries (maximum of 10), newest to oldest." & vbCrLf & vbCrLf

            Dim lastLogToShow As Integer = ev.Entries.Count - EntriesToDisplay
            If lastLogToShow < 0 Then
                lastLogToShow = 0
            End If

            ' 显示所选日志中的最后 10 条记录。
            For index As Integer = ev.Entries.Count - 1 To lastLogToShow Step -1
                Dim CurrentEntry As EventLogEntry = ev.Entries(index)
                rchEventLogOutput.Text &= "Event ID : " & CurrentEntry.InstanceId & vbCrLf
                rchEventLogOutput.Text &= "Entry Type : " & _
                    CurrentEntry.EntryType.ToString() & vbCrLf
                rchEventLogOutput.Text &= "Message : " & _
                    CurrentEntry.Message & vbCrLf & vbCrLf
            Next
        Catch secEx As System.Security.SecurityException
            MsgBox("Security exception in reading the event log.", MsgBoxStyle.OKOnly, Me.Text & " Error")
        Catch ex As Exception
            MsgBox("Error accessing logs on the local machine.", MsgBoxStyle.OKOnly, Me.Text & " Error")
        End Try
    End Sub

    Private Sub lstEntryType_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstEntryType.SelectedIndexChanged
        ' 存储用户在列表框中选择的日志
        logType = CType(lstEntryType.Items(lstEntryType.SelectedIndex()), String)
    End Sub

    Private Sub ReadForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            For Each currentLog As EventLog In EventLog.GetEventLogs()
                lstEntryType.Items.Add(currentLog.LogDisplayName)
            Next
            lstEntryType.SelectedIndex = 0
        Catch secEx As System.Security.SecurityException
            MsgBox("Security exception in reading the event log.", MsgBoxStyle.OKOnly, Me.Text & " Error")
        Catch ex As Exception
            MsgBox("Error accessing logs on the local machine.", MsgBoxStyle.OKOnly, Me.Text & " Error")
        End Try
    End Sub

    Private Sub CloseToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CloseToolStripMenuItem.Click
        Me.Close()
    End Sub

End Class